
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice - {{ $settings->company_name ?? 'POS System' }}</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 20px;
            color: #333;
            line-height: 1.6;
        }
        .invoice-container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .invoice-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #007bff;
        }
        .company-info {
            flex: 1;
        }
        .company-logo {
            text-align: right;
            flex-shrink: 0;
        }
        .company-logo img {
            max-width: 150px;
            height: auto;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            color: #007bff;
            margin-bottom: 10px;
        }
        .company-details {
            color: #666;
            font-size: 14px;
        }
        .company-details p {
            margin: 2px 0;
        }
        .invoice-title {
            text-align: center;
            font-size: 32px;
            font-weight: bold;
            color: #007bff;
            margin: 30px 0;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        .invoice-meta {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
        }
        .invoice-info, .customer-info {
            flex: 1;
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin: 0 10px;
        }
        .invoice-info h3, .customer-info h3 {
            color: #007bff;
            margin-top: 0;
            margin-bottom: 15px;
            font-size: 16px;
            border-bottom: 1px solid #dee2e6;
            padding-bottom: 5px;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
        }
        .info-label {
            font-weight: bold;
            color: #555;
        }
        .info-value {
            color: #333;
        }
        @media print {
            body { margin: 0; padding: 0; }
            .invoice-container { box-shadow: none; }
        }
    </style>
</head>
<body>
    <div class="invoice-container">
        <!-- Invoice Header with Company Information -->
        <div class="invoice-header">
            <div class="company-info">
                @if($settings)
                    <div class="company-name">{{ $settings->company_name ?? 'Company Name' }}</div>
                    <div class="company-details">
                        @if($settings->address)
                            <p><strong>Address:</strong> {{ $settings->address }}</p>
                        @endif
                        @if($settings->number)
                            <p><strong>Phone:</strong> {{ $settings->number }}</p>
                        @endif
                        @if($settings->company_email)
                            <p><strong>Email:</strong> {{ $settings->company_email }}</p>
                        @endif
                        @if($settings->website)
                            <p><strong>Website:</strong> {{ $settings->website }}</p>
                        @endif
                        @if($settings->company_registration_number)
                            <p><strong>Reg. No:</strong> {{ $settings->company_registration_number }}</p>
                        @endif
                    </div>
                @else
                    <div class="company-name">POS System</div>
                    <div class="company-details">
                        <p>Company information not configured</p>
                    </div>
                @endif
            </div>
            <div class="company-logo">
                @if($settings && $settings->logo_path)
                    <img src="{{ asset('logos/' . $settings->logo_path) }}" alt="Company Logo">
                @endif
            </div>
        </div>

        <!-- Invoice Title -->
        <div class="invoice-title">Invoice</div>

        <!-- Invoice and Customer Information -->
        <div class="invoice-meta">
            <div class="invoice-info">
                <h3>Invoice Information</h3>
                <div class="info-row">
                    <span class="info-label">Invoice #:</span>
                    <span class="info-value">{{ $invoice_number ?? 'INV-001' }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Date:</span>
                    <span class="info-value">{{ $invoice_date ?? date('M d, Y') }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Due Date:</span>
                    <span class="info-value">{{ $due_date ?? date('M d, Y', strtotime('+30 days')) }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Currency:</span>
                    <span class="info-value">{{ $settings->currency ?? 'USD' }}</span>
                </div>
            </div>

            <div class="customer-info">
                <h3>Bill To</h3>
                @if(isset($customer))
                    <div class="info-row">
                        <span class="info-label">Name:</span>
                        <span class="info-value">{{ $customer->name ?? 'Customer Name' }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Email:</span>
                        <span class="info-value">{{ $customer->email ?? 'N/A' }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Phone:</span>
                        <span class="info-value">{{ $customer->phone ?? 'N/A' }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Address:</span>
                        <span class="info-value">{{ $customer->address ?? 'N/A' }}</span>
                    </div>
                @else
                    <p>Customer information not available</p>
                @endif
            </div>
        </div>

        <!-- Additional content would go here (items, totals, etc.) -->
        @if(isset($items) && count($items) > 0)
            <!-- Invoice items table would be rendered here -->
        @endif
    </div>
</body>
</html>

